/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.caret.service.ctssh.response;

import java.util.HashMap;

import gov.va.caret.service.ctssh.request.ChainedRequest;

/**
 *
 * @author ronaday
 */
public class ChainedResponse extends Response {
    
    
    /**
     * 
     */
    SimpleResponse[] responses;
    /**
     * 
     */
    ChainedRequest requestIn;
    /**
     * 
     */
    HashMap<String,SimpleResponse> hmResponses;
    
    /**
     * @param req
     * @throws Exception
     */
    public ChainedResponse(ChainedRequest req) throws Exception {

      super(req);
      requestIn = req;
      hmResponses = new HashMap<>();

    }

    /* (non-Javadoc)
     * @see gov.va.caret.service.ctssh.response.Response#addResponse(gov.va.caret.service.ctssh.response.Response)
     */
    @Override
    public void addResponse(Response resp) throws Exception
    {
        hmResponses.put(resp.key(), (SimpleResponse) resp);
    }
 
    /* (non-Javadoc)
     * @see gov.va.caret.service.ctssh.response.Response#report()
     */
    @Override
    public String report() throws Exception
    {
    	StringBuilder sb = new StringBuilder();
    	for(SimpleResponse sr: hmResponses.values())
    	{
    		sb.append(sr.report());
    	}
    	
    	return sb.toString();
    	
    }
    
    public SimpleResponse getResponse(String key)
    {
    	return hmResponses.get(key);
    }
    
    /* (non-Javadoc)
     * @see gov.va.caret.service.ctssh.response.Response#report(java.lang.String)
     */
    @Override
    public String report(String key) throws Exception
    {
    	 return hmResponses.get(key).report();
    }
    
}
